# ZD Screen Recorder SDK

High performance native APIs enable real-time recording of screens, webcams, bitmaps and audio with no system lag, compatible with C#, C++, and VB.NET, no dependencies on external runtime libraries or packages.

## Introduction

ZD Screen Recorder SDK is a feature-rich screen recording software development library that empowers your software with advanced screen recording functionalities, including an innovative multi-source recording feature. By integrating this SDK, developers can swiftly implement professional-level screen recording capabilities, saving significant time and costs compared to developing such features from scratch. Opt for ZD Screen Recorder SDK to elevate your application's capabilities efficiently and cost-effectively. This SDK not only adds advanced features but also ensures stability, professional quality, and reduced maintenance efforts. It's an ideal solution for developers seeking to enhance their applications with cutting-edge recording technology, without the overhead of developing and maintaining complex recording features. Empower your application with ZD Screen Recorder SDK - the smart choice for modern, efficient, and easy-to-use screen recording solutions!

## Getting Started

### System requirements

* OS: Microsoft Windows Vista / 7 / 8 / 8.1 / 10 / 11.
* Programming languages: C# / VB.NET / Visual C++ / Delphi / C++Builder.

### Install the SDK from the NuGet Package Manager in Microsoft Visual Studio (Recommended)

1. Right-click on your project in the Solution Explorer, and then click on "Manage NuGet Packages...", this will open the NuGet Package Manager for your project.
2. In the NuGet Package Manager window, you'll see a "Browse" tab by default. Here you can type in "screen recorder sdk" to search for the `ScreenRecorderSDK` NuGet package in the NuGet.org repository.
3. Select the package and click the "Install" button next to the package version you want to use. You may need to accept the license agreement to confirm the installation. Review the package installation changes that will be made to your project, and then click "OK" to accept the changes.
4. Incorporate the code snippet provided below into your project and proceed to build the solution to confirm that the NuGet package has been properly integrated into your project. Once the build is successful, you are ready to utilize the SDK's features in your project.

### Download the SDK zip package directly from our official website and then install it manually

1. Go to the [SDK download page](https://www.zdsoft.com/screen-recorder-sdk/download.html) to download a standalone ZIP package of the SDK to your computer, and then extract it to a temporary folder.
2. Copy the runtime binaries from the SDK's `ScnLib\bin\x86\*.*` for 32-bit systems and `ScnLib\bin\x64\*.*` for 64-bit systems into the corresponding execution directories of your project.
3. Copy the appropriate header and library files from the SDK's `ScnLib\include` and `ScnLib\lib` directories to the source directories of your project, then incorporate them into your project through the IDE's project manager.
4. Incorporate the code snippet provided below into your project and proceed to build it. This will verify that the SDK library has been correctly configured within your project's environment. Once the build is successful, you are ready to utilize the SDK's features in your project.

### Example C# code for basic routines

* Initialize the SDK at the start of the application (this should be executed only once during application startup).
```csharp
ZDSoft.SDK.ScnLib_InitializeW("");
```
* Initiate a regular screen recording session with the default settings, typically triggered in a button click event handler.
```csharp
ZDSoft.SDK.ScnLib_StartRecording();
```
* After a period of time, conclude the screen recording session, which is also commonly fired in a button click event handler.
```csharp
ZDSoft.SDK.ScnLib_StopRecording();
```
* Uninitialize the SDK during the application's shutdown process (this should be executed only once upon application shutdown).
```csharp
ZDSoft.SDK.ScnLib_Uninitialize();
```
* Browse the `Videos` folder, typically found at `C:\Users\YourName\Videos\`, to view the video you've just recorded.

### Example C++ code for basic routines

* Incorporate the .h and .lib files of the SDK into the main `.cpp` file.
```cpp
#include "ScnLib.h"
#pragma comment(lib, "ScnLib.lib")
```
* Initialize the SDK at the start of the application (this should be executed only once during application startup).
```cpp
ScnLib_InitializeW(NULL);
```
* Initiate a regular screen recording session with the default settings, typically triggered in a button click event handler.
```cpp
ScnLib_StartRecording();
```
* After a period of time, conclude the screen recording session, which is also commonly fired in a button click event handler.
```cpp
ScnLib_StopRecording();
```
* Uninitialize the SDK during the application's shutdown process (this should be executed only once upon application shutdown).
```cpp
ScnLib_Uninitialize();
```
* Browse the `Videos` folder, typically found at `C:\Users\YourName\Videos\`, to view the video you've just recorded.

### Example VB.NET code for basic routines

* Initialize the SDK at the start of the application (this should be executed only once during application startup).
```vbnet
ZDSoft.SDK.ScnLib_InitializeW("")
```
* Initiate a regular screen recording session with the default settings, typically triggered in a button click event handler.
```vbnet
ZDSoft.SDK.ScnLib_StartRecording()
```
* After a period of time, conclude the screen recording session, which is also commonly fired in a button click event handler.
```vbnet
ZDSoft.SDK.ScnLib_StopRecording()
```
* Uninitialize the SDK during the application's shutdown process (this should be executed only once upon application shutdown).
```vbnet
ZDSoft.SDK.ScnLib_Uninitialize()
```
* Browse the `Videos` folder, typically found at `C:\Users\YourName\Videos\`, to view the video you've just recorded.

### Example Delphi code for basic routines

* In the source files where you intend to utilize the SDK, include `ScnLib` in the `uses` section as follows:
```delphi
uses Winapi.Windows, System.Classes, ..., ScnLib;
```
* Initialize the SDK at the start of the application (this should be executed only once during application startup).
```delphi
ScnLib_InitializeW('');
```
* Initiate a regular screen recording session with the default settings, typically triggered in a button click event handler.
```delphi
ScnLib_StartRecording();
```
* After a period of time, conclude the screen recording session, which is also commonly fired in a button click event handler.
```delphi
ScnLib_StopRecording();
```
* Uninitialize the SDK during the application's shutdown process (this should be executed only once upon application shutdown).
```delphi
ScnLib_Uninitialize();
```
* Browse the `Videos` folder, typically found at `C:\Users\YourName\Videos\`, to view the video you've just recorded.

### Advanced example C++ code snippet demonstrates how to conduct recording multiple webcams along with the main screen

```cpp
// Switch the layout context to the main screen block and store the
// previous block index
int oldBlock = ScnLib_SetLayoutContext(0);

// Output a separate video for the main screen (OPTIONAL)
ScnLib_SetVideoPathW(L"C:\\Recordings\\Main Screen.mp4");

// Retrieve the main screen video resolution
int videoWidth = 0, videoHeight = 0;
ScnLib_GetVideoResolution(&videoWidth, &videoHeight);

// We are going to align 3 vertically stacked webcam views against 
// the right side of the main screen, each is 1/3 of the video height
videoHeight /= 3;
// We prefer webcam views with a 4:3 aspect ratio
videoWidth = videoHeight * 4 / 3;

// Switch the layout context to the webcam view block #1
ScnLib_SetLayoutContext(1);

// Output a separate video for the webcam #1 view (OPTIONAL)
ScnLib_SetVideoPathW(L"C:\\Recordings\\Webcam #1.mp4");

// Assuming there are more than 3 webcam devices connected to the PC, 
// select the first webcam device for the webcam #1 view
ScnLib_SelectWebcamDevice(0);

// Align webcam #1 view to the top right corner, offsetting it by its 
// width to the right so it appears adjacent to the main screen
ScnLib_SetWebcamPosition(SCNLIB_POSITION_TOP_RIGHT, -videoWidth, 0);
ScnLib_SetWebcamViewSize(videoWidth, videoHeight);

// Switch the layout context to the webcam view block #2
ScnLib_SetLayoutContext(2);

// Output a separate video for the webcam #2 view (OPTIONAL)
ScnLib_SetVideoPathW(L"C:\\Recordings\\Webcam #2.mp4");

// Assuming there are more than 3 webcam devices connected to the PC, 
// select the second webcam device for the webcam #2 view
ScnLib_SelectWebcamDevice(1);

// Align webcam #2 view to the right side, also offsetting it by its 
// width to the right so it appears adjacent to the main screen
ScnLib_SetWebcamPosition(SCNLIB_POSITION_RIGHT, -videoWidth, 0);
ScnLib_SetWebcamViewSize(videoWidth, videoHeight);

// Switch the layout context to the webcam view block #3
ScnLib_SetLayoutContext(3);

// Output a separate video for the webcam #3 view (OPTIONAL)
ScnLib_SetVideoPathW(L"C:\\Recordings\\Webcam #3.mp4");

// Assuming there are more than 3 webcam devices connected to the PC, 
// select the third webcam device for the webcam #3 view
ScnLib_SelectWebcamDevice(2);

// Align webcam #3 view to the bottom right corner, offsetting it by 
// its width to the right so it appears adjacent to the main screen
ScnLib_SetWebcamPosition(SCNLIB_POSITION_BOTTOM_RIGHT, -videoWidth, 0);
ScnLib_SetWebcamViewSize(videoWidth, videoHeight);

// Switch the layout context to the composition screen
ScnLib_SetLayoutContext(-1);

// Output a separate video for the composition screen
ScnLib_SetVideoPathW(L"C:\\Recordings\\Composition Screen.mp4");

// Restore to the previous layout context
ScnLib_SetLayoutContext(oldBlock);

// Start the recording session right now
ScnLib_StartRecording();
```

## Help

* For version history of the SDK, you can check it out at [https://www.zdsoft.com/screen-recorder-sdk/download.html](https://www.zdsoft.com/screen-recorder-sdk/download.html).

* For comprehensive details on the SDK's APIs, please refer to the `Manual.chm` included in the SDK package, or consult the online API reference at [https://www.zdsoft.com/screen-recorder-sdk/api/](https://www.zdsoft.com/screen-recorder-sdk/api/).

* For inquiries or suggestions regarding the SDK, please reach out to us via the online form available at [https://www.zdsoft.com/contact.html](https://www.zdsoft.com/contact.html).
