// This is a part of the ZD Screen Recorder SDK.
// Copyright (C) 2005-2024; ZD Soft; all rights reserved.

Unit ScnLib;

interface

uses
    Winapi.Windows;

const
    POSITION_TOP_LEFT =      0;
    POSITION_TOP =           1;
    POSITION_TOP_RIGHT =     2;
    POSITION_RIGHT =         3;
    POSITION_BOTTOM_RIGHT =  4;
    POSITION_BOTTOM =        5;
    POSITION_BOTTOM_LEFT =   6;
    POSITION_LEFT =          7;
    POSITION_CENTER =        8;

    WEBCAM_VIEW_PADDING =    0;
    WEBCAM_VIEW_CROPPING =   1;
    WEBCAM_VIEW_STRETCHING = 2;

procedure ScnLib_About(); stdcall; external 'ScnLib.dll';
function  ScnLib_SetLicenseA(const Name: PAnsiChar; const Email: PAnsiChar; const Key: PAnsiChar): LongBool; stdcall; external 'ScnLib.dll';
function  ScnLib_SetLicenseW(const Name: PWideChar; const Email: PWideChar; const Key: PWideChar): LongBool; stdcall; external 'ScnLib.dll';
function  ScnLib_CheckComponents(): LongBool; stdcall; external 'ScnLib.dll';
function  ScnLib_GetLastError(): LongWord; stdcall; external 'ScnLib.dll';
function  ScnLib_InitializeA(const SubDir: PAnsiChar): LongBool; stdcall; external 'ScnLib.dll';
function  ScnLib_InitializeW(const SubDir: PWideChar): LongBool; stdcall; external 'ScnLib.dll';
procedure ScnLib_Uninitialize(); stdcall; external 'ScnLib.dll';
function  ScnLib_LoadSettingsA(RegKey: THandle; const SubKey: PAnsiChar): LongBool; stdcall; external 'ScnLib.dll';
function  ScnLib_LoadSettingsW(RegKey: THandle; const SubKey: PWideChar): LongBool; stdcall; external 'ScnLib.dll';
function  ScnLib_SaveSettingsA(RegKey: THandle; const SubKey: PAnsiChar): LongBool; stdcall; external 'ScnLib.dll';
function  ScnLib_SaveSettingsW(RegKey: THandle; const SubKey: PWideChar): LongBool; stdcall; external 'ScnLib.dll';
function  ScnLib_DeleteSettingsA(RegKey: THandle; const SubKey: PAnsiChar): LongBool; stdcall; external 'ScnLib.dll';
function  ScnLib_DeleteSettingsW(RegKey: THandle; const SubKey: PWideChar): LongBool; stdcall; external 'ScnLib.dll';
procedure ScnLib_ConfigureSettings(ParentWnd: THandle); stdcall; external 'ScnLib.dll';
procedure ScnLib_SetLogPathA(const Path: PAnsiChar; NewLog: LongBool); stdcall; external 'ScnLib.dll';
procedure ScnLib_GetLogPathA(Path: PAnsiChar); stdcall; external 'ScnLib.dll'; // Path >= 260 AnsiChars
procedure ScnLib_SetLogPathW(const Path: PWideChar; NewLog: LongBool); stdcall; external 'ScnLib.dll';
procedure ScnLib_GetLogPathW(Path: PWideChar); stdcall; external 'ScnLib.dll'; // Path >= 260 WideChars
procedure ScnLib_SetVideoPathA(const Path: PAnsiChar); stdcall; external 'ScnLib.dll';
procedure ScnLib_GetVideoPathA(Path: PAnsiChar; Saved: LongBool); stdcall; external 'ScnLib.dll'; // Path >= 260 AnsiChars
procedure ScnLib_SetVideoPathW(const Path: PWideChar); stdcall; external 'ScnLib.dll';
procedure ScnLib_GetVideoPathW(Path: PWideChar; Saved: LongBool); stdcall; external 'ScnLib.dll'; // Path >= 260 WideChars
procedure ScnLib_SetAudioPathA(const Path: PAnsiChar); stdcall; external 'ScnLib.dll';
procedure ScnLib_GetAudioPathA(Path: PAnsiChar; Saved: LongBool); stdcall; external 'ScnLib.dll'; // Path >= 260 AnsiChars
procedure ScnLib_SetAudioPathW(const Path: PWideChar); stdcall; external 'ScnLib.dll';
procedure ScnLib_GetAudioPathW(Path: PWideChar; Saved: LongBool); stdcall; external 'ScnLib.dll'; // Path >= 260 WideChars
procedure ScnLib_SetStreamingUrlA(const URL: PAnsiChar; const Key: PAnsiChar); stdcall; external 'ScnLib.dll';
procedure ScnLib_GetStreamingUrlA(URL: PAnsiChar; Key: PAnsiChar); stdcall; external 'ScnLib.dll'; // URL, Key >= 2048 AnsiChars
procedure ScnLib_SetStreamingUrlW(const URL: PWideChar; const Key: PWideChar); stdcall; external 'ScnLib.dll';
procedure ScnLib_GetStreamingUrlW(URL: PWideChar; Key: PWideChar); stdcall; external 'ScnLib.dll'; // URL, Key >= 2048 WideChars
function  ScnLib_TakeScreenshotA(Path: PAnsiChar; left: Integer; top: Integer; right: Integer; bottom: Integer): LongBool; stdcall; external 'ScnLib.dll'; // Path >= 260 AnsiChars
function  ScnLib_TakeScreenshotW(Path: PWideChar; left: Integer; top: Integer; right: Integer; bottom: Integer): LongBool; stdcall; external 'ScnLib.dll'; // Path >= 260 WideChars
function  ScnLib_SetCaptureWnd(Wnd: THandle; Exclusive: LongBool): THandle; stdcall; external 'ScnLib.dll';
function  ScnLib_GetCaptureWnd(): THandle; stdcall; external 'ScnLib.dll';
procedure ScnLib_SetCaptureRegion(left: Integer; top: Integer; right: Integer; bottom: Integer); stdcall; external 'ScnLib.dll';
procedure ScnLib_GetCaptureRegion(var left: Integer; var top: Integer; var right: Integer; var bottom: Integer); stdcall; external 'ScnLib.dll';
function  ScnLib_SelectCaptureRegionA(var left: Integer; var top: Integer; var right: Integer; var bottom: Integer; var Wnd: THandle; const Tip: PAnsiChar): LongBool; stdcall; external 'ScnLib.dll';
function  ScnLib_SelectCaptureRegionW(var left: Integer; var top: Integer; var right: Integer; var bottom: Integer; var Wnd: THandle; const Tip: PWideChar): LongBool; stdcall; external 'ScnLib.dll';
procedure ScnLib_ShowCaptureRegionFrame(Enable: LongBool); stdcall; external 'ScnLib.dll';
function  ScnLib_GetCaptureRegionFrameWnd(): THandle; stdcall; external 'ScnLib.dll';
procedure ScnLib_LockCaptureRegionFrameAspectRatio(Enable: LongBool); stdcall; external 'ScnLib.dll';
function  ScnLib_IsCaptureRegionFrameAspectRatioLocked(): LongBool; stdcall; external 'ScnLib.dll';
procedure ScnLib_EnableGPUAcceleration(Enable: LongBool); stdcall; external 'ScnLib.dll';
function  ScnLib_IsGPUAccelerationEnabled(): LongBool; stdcall; external 'ScnLib.dll';
procedure ScnLib_EnableGameCaptureMode(Enable: LongBool); stdcall; external 'ScnLib.dll';
function  ScnLib_IsGameCaptureModeEnabled(): LongBool; stdcall; external 'ScnLib.dll';
procedure ScnLib_GetGamePathA(Path: PAnsiChar); stdcall; external 'ScnLib.dll'; // Path >= 260 AnsiChars
procedure ScnLib_GetGamePathW(Path: PWideChar); stdcall; external 'ScnLib.dll'; // Path >= 260 WideChars
function  ScnLib_GetGameWnd(): THandle; stdcall; external 'ScnLib.dll';
function  ScnLib_GetGameFrameRate(): Integer; stdcall; external 'ScnLib.dll';
procedure ScnLib_ShowInGameOverlay(const RGB: Pointer; Width: Integer; Height: Integer; BitCount: Integer); stdcall; external 'ScnLib.dll';
procedure ScnLib_SetInGameOverlayPosition(Position: Integer; MarginX: Integer; MarginY: Integer); stdcall; external 'ScnLib.dll';
procedure ScnLib_GetInGameOverlayPosition(var Position: Integer; var MarginX: Integer; var MarginY: Integer); stdcall; external 'ScnLib.dll';
function  ScnLib_ShowCountdownBox(Seconds: Integer): LongBool; stdcall; external 'ScnLib.dll';
function  ScnLib_StartRecording(): LongBool; stdcall; external 'ScnLib.dll';
function  ScnLib_PauseRecording(): LongBool; stdcall; external 'ScnLib.dll';
function  ScnLib_ResumeRecording(): LongBool; stdcall; external 'ScnLib.dll';
procedure ScnLib_StopRecording(); stdcall; external 'ScnLib.dll';
function  ScnLib_IsRecording(): LongBool; stdcall; external 'ScnLib.dll';
function  ScnLib_IsStreaming(): LongBool; stdcall; external 'ScnLib.dll';
function  ScnLib_IsPaused(): LongBool; stdcall; external 'ScnLib.dll';
function  ScnLib_GetRecTime(): LongWord; stdcall; external 'ScnLib.dll';
procedure ScnLib_GetRecTimeA(Time: PAnsiChar); stdcall; external 'ScnLib.dll'; // Time >= 11 AnsiChars
procedure ScnLib_GetRecTimeW(Time: PWideChar); stdcall; external 'ScnLib.dll'; // Time >= 11 WideChars
procedure ScnLib_ZoomInScreen(Ratio: Double); stdcall; external 'ScnLib.dll';
function  ScnLib_GetZoomRatio(): Double; stdcall; external 'ScnLib.dll';
procedure ScnLib_SetZoomSpeed(Speed: Double); stdcall; external 'ScnLib.dll';
function  ScnLib_GetZoomSpeed(): Double; stdcall; external 'ScnLib.dll';
function  ScnLib_PreviewVideo(Enable: LongBool; Wnd: THandle; Padding: LongBool; BkColor: LongWord): LongBool; stdcall; external 'ScnLib.dll';
function  ScnLib_GetVideoPreviewWnd(): THandle; stdcall; external 'ScnLib.dll';
procedure ScnLib_EnableVideoRecovery(Enable: LongBool); stdcall; external 'ScnLib.dll';
function  ScnLib_IsVideoRecoveryEnabled(): LongBool; stdcall; external 'ScnLib.dll';
function  ScnLib_RecoverVideoFileA(const FromPath: PAnsiChar; const ToPath: PAnsiChar): LongBool; stdcall; external 'ScnLib.dll';
function  ScnLib_RecoverVideoFileW(const FromPath: PWideChar; const ToPath: PWideChar): LongBool; stdcall; external 'ScnLib.dll';
function  ScnLib_GetVideoRecoveryProgress(): Integer; stdcall; external 'ScnLib.dll';
procedure ScnLib_SetVideoResolution(Width: Integer; Height: Integer); stdcall; external 'ScnLib.dll';
procedure ScnLib_GetVideoResolution(var Width: Integer; var Height: Integer); stdcall; external 'ScnLib.dll';
procedure ScnLib_SetVideoFrameRate(FPS: Double); stdcall; external 'ScnLib.dll';
function  ScnLib_GetVideoFrameRate(): Double; stdcall; external 'ScnLib.dll';
procedure ScnLib_SetVideoKeyFrameInterval(Seconds: Double); stdcall; external 'ScnLib.dll';
function  ScnLib_GetVideoKeyFrameInterval(): Double; stdcall; external 'ScnLib.dll';
procedure ScnLib_EnableVideoVariableFrameRate(Enable: LongBool); stdcall; external 'ScnLib.dll';
function  ScnLib_IsVideoVariableFrameRateEnabled(): LongBool; stdcall; external 'ScnLib.dll';
procedure ScnLib_SetVideoPresetProfileA(const Preset: PAnsiChar; const Profile: PAnsiChar); stdcall; external 'ScnLib.dll';
procedure ScnLib_GetVideoPresetProfileA(Preset: PAnsiChar; Profile: PAnsiChar); stdcall; external 'ScnLib.dll'; // Preset, Profile >= 30 AnsiChars
procedure ScnLib_SetVideoPresetProfileW(const Preset: PWideChar; const Profile: PWideChar); stdcall; external 'ScnLib.dll';
procedure ScnLib_GetVideoPresetProfileW(Preset: PWideChar; Profile: PWideChar); stdcall; external 'ScnLib.dll'; // Preset, Profile >= 30 WideChars
procedure ScnLib_SetVideoQuality(CRF: Integer); stdcall; external 'ScnLib.dll';
function  ScnLib_GetVideoQuality(): Integer; stdcall; external 'ScnLib.dll';
procedure ScnLib_SetVideoBitrate(Kbps: Integer); stdcall; external 'ScnLib.dll';
function  ScnLib_GetVideoBitrate(): Integer; stdcall; external 'ScnLib.dll';
function  ScnLib_GetVideoTime(): LongWord; stdcall; external 'ScnLib.dll';
procedure ScnLib_SetAudioBitrate(Kbps: Integer); stdcall; external 'ScnLib.dll';
function  ScnLib_GetAudioBitrate(): Integer; stdcall; external 'ScnLib.dll';
function  ScnLib_GetAudioTime(): LongWord; stdcall; external 'ScnLib.dll';
procedure ScnLib_SetStreamingBitrate(Kbps: Integer); stdcall; external 'ScnLib.dll';
function  ScnLib_GetStreamingBitrate(): Integer; stdcall; external 'ScnLib.dll';
function  ScnLib_GetAudioSourceDeviceCount(Playback: LongBool): Integer; stdcall; external 'ScnLib.dll';
function  ScnLib_GetAudioSourceDeviceA(Playback: LongBool; Index: Integer; Device: PAnsiChar; DeviceID: PAnsiChar): LongBool; stdcall; external 'ScnLib.dll'; // Device, DeviceID >= 260 AnsiChars
function  ScnLib_GetAudioSourceDeviceW(Playback: LongBool; Index: Integer; Device: PWideChar; DeviceID: PWideChar): LongBool; stdcall; external 'ScnLib.dll'; // Device, DeviceID >= 260 WideChars
function ScnLib_SelectAudioSourceDevice(Playback: LongBool; Index: Integer): LongBool; stdcall; external 'ScnLib.dll';
function  ScnLib_GetSelectedAudioSourceDevice(Playback: LongBool): Integer; stdcall; external 'ScnLib.dll';
procedure ScnLib_ConfigureAudioSourceDevices(Playback: LongBool); stdcall; external 'ScnLib.dll';
procedure ScnLib_RecordAudioSource(Playback: LongBool; Enable: LongBool); stdcall; external 'ScnLib.dll';
function  ScnLib_IsRecordAudioSource(Playback: LongBool): LongBool; stdcall; external 'ScnLib.dll';
procedure ScnLib_SetAudioSourceVolume(Playback: LongBool; Volume: Integer); stdcall; external 'ScnLib.dll';
function  ScnLib_GetAudioSourceVolume(Playback: LongBool): Integer; stdcall; external 'ScnLib.dll';
procedure ScnLib_MonitorVolumeLevel(Enable: LongBool); stdcall; external 'ScnLib.dll';
function  ScnLib_IsMonitoringVolumeLevel(): LongBool; stdcall; external 'ScnLib.dll';
function  ScnLib_GetAudioSourceVolumeLevel(Playback: LongBool): Integer; stdcall; external 'ScnLib.dll';
procedure ScnLib_SetMicrophoneDelay(Milliseconds: Integer); stdcall; external 'ScnLib.dll';
function  ScnLib_GetMicrophoneDelay(): Integer; stdcall; external 'ScnLib.dll';
function  ScnLib_SetLayoutContext(Block: Integer): Integer; stdcall; external 'ScnLib.dll';
function  ScnLib_GetLayoutContext(): Integer; stdcall; external 'ScnLib.dll';
function  ScnLib_GetWebcamDeviceCount(): Integer; stdcall; external 'ScnLib.dll';
function  ScnLib_GetWebcamDeviceA(Index: Integer; Device: PAnsiChar; DeviceID: PAnsiChar): LongBool; stdcall; external 'ScnLib.dll'; // Device, DeviceID >= 260 AnsiChars
function  ScnLib_GetWebcamDeviceW(Index: Integer; Device: PWideChar; DeviceID: PWideChar): LongBool; stdcall; external 'ScnLib.dll'; // Device, DeviceID >= 260 WideChars
function  ScnLib_SelectWebcamDevice(Index: Integer): LongBool; stdcall; external 'ScnLib.dll';
function  ScnLib_GetSelectedWebcamDevice(): Integer; stdcall; external 'ScnLib.dll';
function  ScnLib_PreviewWebcam(Enable: LongBool; Wnd: THandle; Padding: LongBool; BkColor: LongWord): LongBool; stdcall; external 'ScnLib.dll';
function  ScnLib_GetWebcamPreviewWnd(): THandle; stdcall; external 'ScnLib.dll';
procedure ScnLib_RecordWebcamOnly(Enable: LongBool); stdcall; external 'ScnLib.dll';
function  ScnLib_IsRecordWebcamOnly(): LongBool; stdcall; external 'ScnLib.dll';
procedure ScnLib_InputWebcamFrame(const RGB: Pointer; Width: Integer; Height: Integer; BitCount: Integer); stdcall; external 'ScnLib.dll';
procedure ScnLib_SetWebcamResolution(Width: Integer; Height: Integer); stdcall; external 'ScnLib.dll';
procedure ScnLib_GetWebcamResolution(var Width: Integer; var Height: Integer); stdcall; external 'ScnLib.dll';
procedure ScnLib_SetWebcamDirection(Mirroring: LongBool; Flipping: LongBool); stdcall; external 'ScnLib.dll';
procedure ScnLib_GetWebcamDirection(var Mirroring: LongBool; var Flipping: LongBool); stdcall; external 'ScnLib.dll';
procedure ScnLib_SetWebcamViewMode(ViewMode: Integer); stdcall; external 'ScnLib.dll';
function  ScnLib_GetWebcamViewMode(): Integer; stdcall; external 'ScnLib.dll';
procedure ScnLib_SetWebcamPosition(Position: Integer; MarginX: Integer; MarginY: Integer); stdcall; external 'ScnLib.dll';
procedure ScnLib_GetWebcamPosition(var Position: Integer; var MarginX: Integer; var MarginY: Integer); stdcall; external 'ScnLib.dll';
procedure ScnLib_SetWebcamViewSize(ViewWidth: Integer; ViewHeight: Integer); stdcall; external 'ScnLib.dll';
procedure ScnLib_GetWebcamViewSize(var ViewWidth: Integer; var ViewHeight: Integer); stdcall; external 'ScnLib.dll';
function  ScnLib_IsLogoImagePresent(): LongBool; stdcall; external 'ScnLib.dll';
function  ScnLib_SetLogoImageA(const Path: PAnsiChar): LongBool; stdcall; external 'ScnLib.dll';
procedure ScnLib_GetLogoImageA(Path: PAnsiChar); stdcall; external 'ScnLib.dll'; // Path >= 260 AnsiChars
function  ScnLib_SetLogoImageW(const Path: PWideChar): LongBool; stdcall; external 'ScnLib.dll';
procedure ScnLib_GetLogoImageW(Path: PWideChar); stdcall; external 'ScnLib.dll'; // Path >= 260 WideChars
procedure ScnLib_UpdateLogoImage(const RGB: Pointer; Width: Integer; Height: Integer; BitCount: Integer); stdcall; external 'ScnLib.dll';
procedure ScnLib_SetLogoImagePosition(Position: Integer; MarginX: Integer; MarginY: Integer); stdcall; external 'ScnLib.dll';
procedure ScnLib_GetLogoImagePosition(var Position: Integer; var MarginX: Integer; var MarginY: Integer); stdcall; external 'ScnLib.dll';
procedure ScnLib_SetLogoImageOpacity(Opacity: Double); stdcall; external 'ScnLib.dll';
function  ScnLib_GetLogoImageOpacity(): Double; stdcall; external 'ScnLib.dll';
function  ScnLib_IsLogoTextPresent(): LongBool; stdcall; external 'ScnLib.dll';
function  ScnLib_SetLogoTextA(const Text: PAnsiChar): LongBool; stdcall; external 'ScnLib.dll';
procedure ScnLib_GetLogoTextA(Text: PAnsiChar); stdcall; external 'ScnLib.dll'; // Text >= 1024 AnsiChars
function  ScnLib_SetLogoTextW(const Text: PWideChar): LongBool; stdcall; external 'ScnLib.dll';
procedure ScnLib_GetLogoTextW(Text: PWideChar); stdcall; external 'ScnLib.dll'; // Text >= 1024 WideChars
function  ScnLib_SetLogoTextStyleA(const Font: tagLogFontA; Color: LongWord; Shadow: LongBool): LongBool; stdcall; external 'ScnLib.dll';
procedure ScnLib_GetLogoTextStyleA(var Font: tagLogFontA; var Color: LongWord; var Shadow: LongBool); stdcall; external 'ScnLib.dll';
function  ScnLib_SetLogoTextStyleW(const Font: tagLogFontW; Color: LongWord; Shadow: LongBool): LongBool; stdcall; external 'ScnLib.dll';
procedure ScnLib_GetLogoTextStyleW(var Font: tagLogFontW; var Color: LongWord; var Shadow: LongBool); stdcall; external 'ScnLib.dll';
procedure ScnLib_SetLogoTextPosition(Position: Integer; MarginX: Integer; MarginY: Integer); stdcall; external 'ScnLib.dll';
procedure ScnLib_GetLogoTextPosition(var Position: Integer; var MarginX: Integer; var MarginY: Integer); stdcall; external 'ScnLib.dll';
procedure ScnLib_SetLogoTextOpacity(Opacity: Double); stdcall; external 'ScnLib.dll';
function  ScnLib_GetLogoTextOpacity(): Double; stdcall; external 'ScnLib.dll';
procedure ScnLib_RecordCursor(Enable: LongBool); stdcall; external 'ScnLib.dll';
function  ScnLib_IsRecordCursor(): LongBool; stdcall; external 'ScnLib.dll';
procedure ScnLib_SetCursorUnscaled(Enable: LongBool); stdcall; external 'ScnLib.dll';
function  ScnLib_IsCursorUnscaled(): LongBool; stdcall; external 'ScnLib.dll';
procedure ScnLib_AddCursorEffects(Highlight: LongBool; ClickEffects: LongBool; Track: LongBool; ClickSound: LongBool); stdcall; external 'ScnLib.dll';
procedure ScnLib_GetCursorEffects(var Highlight: LongBool; var ClickEffects: LongBool; var Track: LongBool; var ClickSound: LongBool); stdcall; external 'ScnLib.dll';
procedure ScnLib_SetCursorEffectsColors(HighlightColor: LongWord; LeftClickColor: LongWord; RightClickColor: LongWord; TrackColor: LongWord); stdcall; external 'ScnLib.dll';
procedure ScnLib_GetCursorEffectsColors(var HighlightColor: LongWord; var LeftClickColor: LongWord; var RightClickColor: LongWord; var TrackColor: LongWord); stdcall; external 'ScnLib.dll';
procedure ScnLib_SetCursorEffectsImagesA(const Highlight: PAnsiChar; const LeftClick: PAnsiChar; const RightClick: PAnsiChar); stdcall; external 'ScnLib.dll';
procedure ScnLib_GetCursorEffectsImagesA(Highlight: PAnsiChar; LeftClick: PAnsiChar; RightClick: PAnsiChar); stdcall; external 'ScnLib.dll'; // Highlight, LeftClick, RightClick >= 260 AnsiChars
procedure ScnLib_SetCursorEffectsImagesW(const Highlight: PWideChar; const LeftClick: PWideChar; const RightClick: PWideChar); stdcall; external 'ScnLib.dll';
procedure ScnLib_GetCursorEffectsImagesW(Highlight: PWideChar; LeftClick: PWideChar; RightClick: PWideChar); stdcall; external 'ScnLib.dll'; // Highlight, LeftClick, RightClick >= 260 WideChars

implementation

end.