﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Threading;

namespace ScreenWebcams
{
    /// <summary>
    /// Interaction logic for App.xaml
    /// </summary>
    public partial class App : Application
    {
        public App()
        {
            this.DispatcherUnhandledException += App_DispatcherUnhandledException;
        }

        private void App_DispatcherUnhandledException(object sender, DispatcherUnhandledExceptionEventArgs e)
        {
            if (e.Exception is DllNotFoundException dllEx)
            {
                MessageBox.Show(
                    $"A required DLL is missing:\n\n{dllEx.Message}\n\n" +
                    "Please double-click the 'CopyDLLx64.bat' file to automatically copy the necessary DLLs to this location.",
                    "Error", MessageBoxButton.OK, MessageBoxImage.Error);

                Application.Current.Shutdown();
            }
            else
            {
                MessageBox.Show(
                    $"An unhandled exception caught:\n\n{e.Exception.Message}\n\n" +
                    "Please let us know about this issue, and we'll provide assistance.",
                    "Error", MessageBoxButton.OK, MessageBoxImage.Error);
            }

            e.Handled = true;
        }
    }
}
